#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Distance estimated JuliaMod01.fsh   by    rucksack 
//https://www.shadertoy.com/view/DdySRz
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const int iterations = 50;

// f_n(z) = f_n-1(z)^2 + c, f_0(z) = z
vec2 next(vec2 z, vec2 c) {
    float real = z.x * z.x - z.y * z.y + c.x;
    float imag = 2. * z.x * z.y + c.y;
    return vec2(real, imag);
}

// f'_n(z) = 2*f_n-1(z)*f'_n-1(z), f'_0(z) = 1
vec2 derivative(vec2 z, vec2 dr) {
    float real = z.x * dr.x - z.y * dr.y;
    float imag = z.x * dr.y + z.y * dr.x;
    return vec2(real, imag);
}

float map(vec2 z, vec2 c, out int i) {
    i = 0;
    vec2 dr = vec2(1, 0);
    float d = 0.;
    for (; i < iterations && length(z) < 2.*length(c); i++) {
        z = next(z, c);
        dr = derivative(z, dr);
    }
    return .5 * log(length(z)) * length(z)/length(dr);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    vec2 uv = (fragCoord-.5*iResolution.xy)/iResolution.y;
    
    float r = 0.7885;
    float a = iTime + 2.88;
    vec2 c = r * vec2(cos(a), sin(a));
    //c = vec2(-0.4, 0.2);
    
    uv *= 3.*r; 
    int escape_time;
    float d = map(uv, c, escape_time);
    float f1 = (1. - .2*sqrt(d));
    float f2 = sqrt(.4*abs(d));
    float esc = float(10 + escape_time) / float(iterations);
    vec3 col = esc * vec3(f2, 1, f1);

    fragColor = vec4(col,1);
    

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

